(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5196,        154]*)
(*NotebookOutlinePosition[      5896,        178]*)
(*  CellTagsIndexPosition[      5852,        174]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Ejercicio 1", "Exercise"],

Cell["\<\
Sea f(x,y,z) un campo escalar y S una superficie dada por sus ecuaciones \
param\[EAcute]tricas \[Gamma](s,t)=(x(s,t),y(s,t),z(s,t)). Define un comando \
(cuya sintaxis debes decidir para que sea f\[AAcute]cil de ejecutar en cada \
caso concreto) que calcule la derivada de f en un punto (a,b,c), que se \
supone que pertenece a S, en la direcci\[OAcute]n de la normal a S en dicho \
punto inducida por la parametrizaci\[OAcute]n dada. Comprueba tu comando con \
dos ejemplos de tu elecci\[OAcute]n.\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2 ", "Exercise"],

Cell["\<\
Comprueba en general y de forma simb\[OAcute]lica las identidades:
a) rot(grad f)=0;
b) div(rot F)=0.\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3 ", "Exercise"],

Cell[TextData[{
  "Define un comando que calcule de forma aproximada la integral de \
superficie de un campo escalar sobre una superficie S. Debes suponer dados un \
campo escalar f(x,y,z) y una superficie S por sus ecuaciones \
param\[EAcute]tricas  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](s, t) = \((x(s, t), y(s, t), 
          z(s, t))\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`a \[LessEqual] s \[LessEqual] b\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`c \[LessEqual] t \[LessEqual] d\)]],
  ". Debes dividir por puntos ",
  Cell[BoxData[
      \(TraditionalForm\`s\_j = a + \(j(b - a)\)/n\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`t\_k = c + \(k(d - c)\)/m\)]],
  " los intervalos [a,b] y [c,d] y formar la suma"
}], "ExerciseText"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          FormBox[\(\[Sum]\+\(j = 1\)\%n\[Sum]\+\(k = 1\)\%m\),
            "TraditionalForm"],
          "TraditionalForm"], 
        FormBox[
          RowBox[{\(f(\[Gamma](s\_j, t\_k))\), "||", 
            RowBox[{
              FormBox[
                
                FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ s\) \((s\_j, 
                      t\_k)\)\),
                  "TraditionalForm"],
                "TraditionalForm"], "\[Times]", 
              FormBox[
                
                FormBox[\(\(\[PartialD]\ \[Gamma]\/\[PartialD]\ t\) \((s\_j, 
                      t\_k)\)\),
                  "TraditionalForm"],
                "TraditionalForm"]}], "||"}],
          
          "TraditionalForm"], \((s\_j - s\_\(j - 1\))\), \((t\_k - 
            t\_\(k - 1\))\)}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Elige la sintaxis del comando de manera que sea f\[AAcute]cil de aplicar. \
El comando debe trabajar num\[EAcute]ricamente.\nUsa el comando definido para \
calcular con un error menor que ",
  Cell[BoxData[
      \(TraditionalForm\`10\^\(-3\)\)]],
  " respecto a su valor exacto (que tambi\[EAcute]n necesitar\[AAcute]s \
calcular) las integrales de superficie siguientes:\na) ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = x\^2 + y\^2 + z\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](s, t) = \((sen\ t\ cos\ s, sen\ t\ sen\ s, 
          cos\ t)\), \ \ 0 \[LessEqual] s, t \[LessEqual] \[Pi]\)]],
  ".\nb) ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = 
        x\ z, \[Gamma](s, t) = \((s, t, 
          1 - s\^2 - t\^2)\), \ \ 0 \[LessEqual] s, t \[LessEqual] 1\)]],
  "."
}], "ExerciseText"]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 31, 0, 68, "Exercise"],
Cell[1810, 55, 531, 8, 119, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2378, 68, 32, 0, 68, "Exercise"],
Cell[2413, 70, 133, 4, 109, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2583, 79, 32, 0, 68, "Exercise"],
Cell[2618, 81, 792, 21, 119, "ExerciseText"],
Cell[3413, 104, 912, 25, 77, "Text"],
Cell[4328, 131, 852, 20, 169, "ExerciseText"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

